/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.system;

import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.pa.system.PIFsp;
import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.system.PASystemLock;
import com.ibm.hwmca.fw.pa.util.LockAcquisitionException;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.w3c.dom.Node;

public class PICecFsp
extends PIFsp {
    private static final String TRACE_MASKT = "PPACECFT";
    private static final String TRACE_MASKF = "PPACECFF";
    private static final String TRACE_MASKD = "PPACECFD";
    public PICecFspPersistentData picfPD = null;
    private static final String CEC_LOCATION_CODE = "PRIMARY";
    public static final PASystemLock ARBITRATION_LOCK = new PASystemLock((Object)"Arbitration");
    private transient Object dataLock = null;

    public PICecFsp() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor");
        this.initPersistentData();
    }

    public PICecFsp(String string, String string2, String string3) {
        super(string, string2, string3);
        this.initPersistentData();
    }

    public PICecFsp(CIMInstance cIMInstance, boolean bl) {
        super(cIMInstance, bl);
        this.initPersistentData();
    }

    public PICecFsp(PersistentData persistentData) throws PersistenceException {
        super(((PICecFspPersistentData)persistentData).superData);
        this.initPersistentData();
        this.setLastLogEntryID(((PICecFspPersistentData)persistentData).lastLeid);
        Trace.trace((String)TRACE_MASKD, (Object)"Rebuilt PICecFsp [");
        Trace.trace((String)TRACE_MASKD, (Object)("lastLeid=" + Long.toString(this.getLastLogEntryID(), 16)));
        Trace.trace((String)TRACE_MASKD, (Object)"]");
    }

    private void initPersistentData() {
        this.picfPD = new PICecFspPersistentData();
        this.picfPD.superData = super.getPersistentData();
    }

    public PersistentData getPersistentData() {
        if (this.picfPD.superData == null) {
            this.picfPD.superData = super.getPersistentData();
        }
        return this.picfPD;
    }

    public String getCIMClass() {
        return "IBMHSC_ComputerSystem";
    }

    public void setCIMInstance(CIMInstance cIMInstance) {
        super.setCIMInstance(cIMInstance);
        this.setMOID(PICec.objectPathToId(this.getCIMObjectPath()));
    }

    protected void parseCIMInstance() {
        super.parseCIMInstance();
        try {
            String string = this.getCIMSystemName();
            this.setMachineType(string.substring(0, string.indexOf("-")));
            this.setMachineModel(string.substring(string.indexOf("-") + 1, string.indexOf("*")));
            this.setMachineSerial(string.substring(string.indexOf("*") + 1));
            this.setSystemName(this.getMTMS());
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception obtaining MTMS - making 0-0/0");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            this.setMachineType("0");
            this.setMachineModel("0");
            this.setMachineSerial("0");
            this.setSystemName(this.getMTMS());
        }
    }

    public boolean isDummy() {
        return this.getCIMSystemName().startsWith("0-0");
    }

    public String getLocationCode() {
        return CEC_LOCATION_CODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastLogEntryID(long l) {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.picfPD.lastLeid = l;
            this.picfPD.sLastLeid = Long.toString(l, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLogEntryID() {
        if (this.dataLock == null) {
            this.dataLock = new Object();
        }
        Object object = this.dataLock;
        synchronized (object) {
            return this.picfPD.lastLeid;
        }
    }

    public boolean canCommunicate() {
        if (this.getCIMInstance() == null) {
            return false;
        }
        int n = 0;
        try {
            n = ((UnsignedInt8)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "State").getValue()).intValue();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)this.getSystemTrace("Exception obtaining 'State' attribute"));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            return false;
        }
        switch (n) {
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
            case 6: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 32: {
                return true;
            }
            case 33: {
                return true;
            }
            case 253: {
                return true;
            }
            case 254: {
                return false;
            }
            case 251: {
                return true;
            }
            case 250: {
                return false;
            }
            case 240: {
                return false;
            }
            case 241: {
                return false;
            }
            case 242: {
                return false;
            }
            case 243: {
                return true;
            }
            case 17: {
                return true;
            }
        }
        return false;
    }

    public String getParentSystemModelType() {
        if (this.getCIMInstance() == null) {
            return null;
        }
        try {
            return (String)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "ParentSystemModelType").getValue();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)this.getSystemTrace("Exception obtaining 'ParentSystemModelType' attribute"));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            return null;
        }
    }

    public String getParentSystemSerial() {
        if (this.getCIMInstance() == null) {
            return null;
        }
        try {
            return (String)PIHscUtil.getCIMAttribute(this.getCIMInstance(), "ParentSystemSerial").getValue();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)this.getSystemTrace("Exception obtaining 'ParentSystemSerial' attribute"));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            return null;
        }
    }

    public static Enumeration getLiveSystems(int n) throws Exception {
        Vector<PICecFsp> vector;
        block9: {
            Trace.trace((String)TRACE_MASKD, (Object)"--> getLiveSystems");
            vector = new Vector<PICecFsp>();
            try {
                String string = new PICecFsp().getCIMClass();
                Enumeration enumeration = PIMachineSystem.getCIMInstances(n, string);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    Object var4_5 = null;
                    PICecFsp pICecFsp = null;
                    while (enumeration.hasMoreElements()) {
                        pICecFsp = new PICecFsp((CIMInstance)enumeration.nextElement(), true);
                        if (pICecFsp.isDummy()) {
                            Trace.trace((String)TRACE_MASKD, (Object)("Ignoring dummy CIMInstance [" + pICecFsp.getCIMSystemName() + "]"));
                            continue;
                        }
                        pICecFsp.setCIMRetryTime(n);
                        Trace.trace((String)TRACE_MASKD, (Object)("System key=" + pICecFsp.getUniqueCIMKey()));
                        try {
                            Trace.trace((String)TRACE_MASKD, (Object)("System state=" + ((UnsignedInt8)PIHscUtil.getCIMAttribute(pICecFsp.getCIMInstance(), "State").getValue()).intValue()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        vector.add(pICecFsp);
                    }
                    break block9;
                }
                if (enumeration == null) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Null enumeration returned by CIM");
                } else {
                    Trace.trace((String)TRACE_MASKD, (Object)("No " + string + " instances returned by CIM"));
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"<-- getLiveSystems: Exception caught obtaining systems");
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)("<-- getLiveSystems (" + vector.size() + " systems)"));
        return vector.elements();
    }

    protected UnsignedInt32 getCIMLockType(PASystemLock pASystemLock) throws LockAcquisitionException {
        if (pASystemLock.equals((Object)ARBITRATION_LOCK)) {
            return new UnsignedInt32(1L);
        }
        return super.getCIMLockType(pASystemLock);
    }

    public static void main(String[] stringArray) {
        try {
            PIHscUtil.initHscUtil(3);
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem");
            cIMObjectPath.setNameSpace("root/ibmhscS1_0");
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances("localhost", cIMObjectPath, false);
            if (enumeration == null) {
                Trace.trace((String)TRACE_MASKT, (Object)"Null enumeration returned by CIM");
                System.out.println("Null enumeration returned by CIM");
                return;
            }
            CIMObjectPath cIMObjectPath2 = null;
            String string = null;
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                string = (String)PIHscUtil.getCIMAttribute("localhost", cIMObjectPath2, "Name").getValue();
                bl = string.equals(stringArray[0]);
            }
            if (!bl) {
                Trace.trace((String)TRACE_MASKD, (Object)("Didn't find CIM object for CEC=" + stringArray[0]));
                System.out.println("Didn't find CIM object for CEC=" + stringArray[0]);
                return;
            }
            Trace.trace((String)TRACE_MASKD, (Object)("CEC name=" + string));
            System.out.println("CEC name=" + string);
            PICecFsp pICecFsp = new PICecFsp(PIHscUtil.getCIMInstance("localhost", cIMObjectPath2, false), true);
            if (stringArray[1].equals("list")) {
                Trace.trace((String)TRACE_MASKD, (Object)"Attempting PEL list...");
                System.out.println("Attempting PEL list...");
                long l = 0L;
                l = stringArray[2].startsWith("0x") ? Long.parseLong(stringArray[2].substring(2), 16) : new Long(stringArray[2]);
                long l2 = 0L;
                l2 = stringArray[3].startsWith("0x") ? Long.parseLong(stringArray[3].substring(2), 16) : new Long(stringArray[3]);
                Vector vector = pICecFsp.getPELLogEntryIDs(null, l != 0L, l, l2 != 0L, l2);
                Trace.trace((String)TRACE_MASKD, (Object)("id vector size:" + vector.size()));
                System.out.println("id vector size:" + vector.size());
                long l3 = 0L;
                for (int i = 0; i < vector.size(); ++i) {
                    l3 = (Long)vector.get(i);
                    Trace.trace((String)TRACE_MASKD, (Object)("Log " + (i + 1) + ": " + Long.toString(l3, 16)));
                    System.out.println("Log " + (i + 1) + ": " + Long.toString(l3, 16));
                }
            } else {
                Long l = null;
                l = stringArray[1].startsWith("0x") ? new Long(Long.parseLong(stringArray[1].substring(2), 16)) : new Long(stringArray[1]);
                Trace.trace((String)TRACE_MASKD, (Object)("Attempting PEL retrieval (" + Long.toString(l, 16) + ")..."));
                System.out.println("Attempting PEL retrieval (" + Long.toString(l, 16) + ")...");
                byte[] byArray = pICecFsp.getPEL(l);
                if (byArray == null || byArray.length == 0) {
                    System.out.println("Retrieval failed or empty.  Exiting.");
                    return;
                }
                System.out.println("PEL >> ");
                System.out.println(HexString.toHex((byte[])byArray, (int)0, (int)byArray.length, (int)4, (int)16, (boolean)true));
                System.out.println("<< PEL");
                if (stringArray.length > 1 && stringArray[2].equalsIgnoreCase("true")) {
                    PelDataEvent pelDataEvent = new PelDataEvent((Object)pICecFsp);
                    pelDataEvent.setSystem((PASystem)pICecFsp);
                    pelDataEvent.setData((Object)byArray);
                    LogAttributes logAttributes = null;
                    if (pelDataEvent.isError()) {
                        Trace.trace((String)TRACE_MASKD, (Object)"Error Event - logging for analysis");
                        System.out.println("Error Event - logging for analysis");
                        logAttributes = LogAttributes.ERROR_LOG;
                    } else {
                        Trace.trace((String)TRACE_MASKD, (Object)"Informational Event - logging only");
                        System.out.println("Informational Event - logging only");
                        logAttributes = LogAttributes.INFO_LOG;
                    }
                    Log log = new Log(96, 1, 0, "PEL Event", null, null, null, null);
                    log.add((byte)3, (Object)byArray);
                    StringBuffer stringBuffer = new StringBuffer();
                    XMLHelper.outToXML((Object)((Object)pICecFsp), (StringBuffer)stringBuffer, ((Object)((Object)pICecFsp)).getClass());
                    log.add((byte)4, (Object)stringBuffer.toString());
                    log.log(logAttributes);
                }
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKD, (Object)"Exception");
            Trace.trace((String)TRACE_MASKD, (Object)exception);
            exception.printStackTrace();
        }
    }

    public static class PICecFspPersistentData
    implements PersistentData,
    XMLEncodeable {
        private static final long serialVersionUID = 8291972424308249261L;
        public PersistentData superData = null;
        public long lastLeid = 0L;
        protected String sLastLeid = "";

        public void toXML(StringBuffer stringBuffer) {
            stringBuffer.append("<PersistentData class=\"" + this.getClass().getName() + "\"");
            stringBuffer.append(" lastLeid=\"" + this.lastLeid + "\"");
            stringBuffer.append("/>");
        }

        public void fromXML(Node node) {
            Node node2 = node.getChildNodes().item(0);
            if (!node2.getNodeName().equals("PersistentData")) {
                Trace.trace((String)PICecFsp.TRACE_MASKT, (Object)"<-> PICecFspPersistentData.fromXML: necessary 'PersistentData' node not found");
                return;
            }
            this.lastLeid = Long.valueOf(XMLHelper.getAttributeValue((Node)node2, (String)"lastLeid"));
        }
    }
}

